#include <iostream>

#include "movelist.h"
#include "move.h"
#include "squares.h"
#include "piece.h"
#include "defs.h"
#include "material.h"
#include "attack.h"
#include "log.h"

using namespace std;
const uint HISMAX = 50000;

#define	HASH	2600000
#define	M_KILLER	2500000
#define	WIN_CAPT	2400000
#define	Q_PROM_CAPT	2300000
#define	Q_PROM	2200000
#define	GCAP_QQ	2100000
#define	GCAP_RR	2000000
#define	GCAP_NN	1900000
#define	GCAP_BB	1800000
#define	GCAP_PP	1700000
#define	SEECAP	1600000
#define	KILLER1	1500000
#define	KILLER1_PLY	1400000
#define	KILLER2	1300000
#define	KILLER2_PLY	1200000
#define	OO	1100000
#define	OOO	1000000
#define	MINORPROM	900000



using namespace std;



static const int equalcap[13] =
{0,GCAP_PP,GCAP_PP,GCAP_NN,GCAP_NN,
   GCAP_BB,GCAP_BB,GCAP_RR,GCAP_RR,
   GCAP_QQ,GCAP_QQ,0,0};

/*moveorderingpsqt*/
static const int orderpawn[64] = {
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
10	,	10	,	10	,	10	,	10	,	10	,	10	,	10	,
20	,	20	,	20	,	20	,	20	,	20	,	20	,	20	,
30	,	30	,	30	,	30	,	30	,	30	,	30	,	30	,
40	,	40	,	40	,	40	,	40	,	40	,	40	,	40	,
60	,	60	,	60	,	60	,	60	,	60	,	60	,	60	,
80	,	80	,	80	,	80	,	80	,	80	,	80	,	80	,
100	,	100	,	100	,	100	,	100	,	100	,	100	,	100
};

static const int orderknight[64] = {
0	,	10	,	10	,	10	,	10	,	10	,	10	,	0	,
10	,	15	,	30	,	30	,	30	,	30	,	15	,	10	,
10	,	20	,	50	,	50	,	50	,	50	,	20	,	10	,
10	,	20	,	50	,	80	,	80	,	50	,	20	,	10	,
10	,	20	,	50	,	80	,	80	,	50	,	20	,	10	,
10	,	20	,	50	,	50	,	50	,	50	,	20	,	10	,
10	,	15	,	30	,	30	,	30	,	30	,	15	,	10	,
0	,	10	,	10	,	10	,	10	,	10	,	10	,	0
};

static const int orderbishop[64] = {
80	,	60	,	50	,	30	,	30	,	50	,	60	,	80	,
60	,	80	,	60	,	50	,	50	,	60	,	80	,	60	,
50	,	60	,	80	,	60	,	60	,	80	,	60	,	50	,
30	,	50	,	60	,	80	,	80	,	60	,	50	,	30	,
30	,	50	,	60	,	80	,	80	,	60	,	50	,	30	,
50	,	60	,	80	,	60	,	60	,	80	,	60	,	50	,
60	,	80	,	60	,	50	,	50	,	60	,	80	,	60	,
80	,	60	,	50	,	30	,	30	,	50	,	60	,	80
};

static const int orderkingmid[64] = {
80	,	80	,	80	,	40	,	40	,	70	,	80	,	40	,
20	,	20	,	20	,	10	,	10	,	20	,	20	,	20	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0
};

static const int orderkingend[64] = {
0	,	10	,	20	,	40	,	40	,	20	,	10	,	0	,
10	,	20	,	30	,	50	,	50	,	30	,	20	,	10	,
20	,	30	,	40	,	60	,	60	,	40	,	30	,	20	,
40	,	50	,	60	,	80	,	80	,	60	,	50	,	40	,
40	,	50	,	60	,	80	,	80	,	60	,	50	,	40	,
20	,	30	,	40	,	60	,	60	,	40	,	30	,	20	,
10	,	20	,	30	,	50	,	50	,	30	,	20	,	10	,
0	,	10	,	20	,	40	,	40	,	20	,	10	,	0
};

static const int orderrook[64] = {
10	,	10	,	10	,	20	,	20	,	10	,	10	,	10	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
0	,	0	,	0	,	0	,	0	,	0	,	0	,	0	,
20	,	20	,	20	,	20	,	20	,	20	,	20	,	20	,
80	,	80	,	80	,	80	,	80	,	80	,	80	,	80	,
40	,	40	,	40	,	40	,	40	,	40	,	40	,	40
};


static const int *midordertab[] = {
    0,
    orderpawn, orderpawn,
    orderknight, orderknight,
    orderbishop, orderbishop,
    orderrook, orderrook,
    orderrook, orderrook,
    orderkingmid, orderkingmid
};

static const int *endordertab[] = {
    0,
    orderpawn, orderpawn,
    orderknight, orderknight,
    orderbishop, orderbishop,
    orderrook, orderrook,
    orderrook, orderrook,
    orderkingend, orderkingend
};

void cMovelist::init_opt()
{
    opt->histab = true;
    opt->mvvlva = true;
    opt->killer = true;
    opt->hashmove = true;
    opt->matekiller = true;
}

void cMovelist::resethistab()
{
    uint pce,sq;
    for(pce = pE; pce <= pbK; ++pce)
    {
        for(sq = 0; sq < BRDSQ; ++sq)
        histab.value[pce][sq] = 1;
    }
    histab.max = 1;
}

void cMovelist::resetstats()
{
    stats.killer1=stats.killer2=stats.matekiller=0;
    stats.histab=stats.capture=stats.badcapture=stats.hashmove=0;
    stats.qprom=stats.minorprom=0;
    stats.epcapture=stats.castle=0;
}

void cMovelist::resetkillers()
{
    for(uint i = 0; i < maxply; ++i)
    {
        killers.k1[i]=killers.k2[i]=killers.mk[i]=NULLMOVE;
    }
}

void cMovelist::scoremove(uint move, uint depth, uint pce)
{
    uint to = TO(move);
    ASS(onbrd(to));
    ASS(piecegood(pce));
    ASS(depth>=0&&depth<maxply);

    //histab.value[pce][to] += depth*depth;
    histab.value[pce][to] += depth;
    if(histab.value[pce][to]  > histab.max)
    histab.max = histab.value[pce][to];

}


void cMovelist::failowmove(uint move, uint depth, uint pce)
{
    uint to = TO(move);
    ASS(onbrd(to));
    ASS(piecegood(pce));
    ASS(depth>=0&&depth<maxply);

    if(histab.value[pce][to]>depth*depth)
    {
    histab.value[pce][to] -= depth*depth;
    if(histab.value[pce][to]  < 1)
    histab.value[pce][to] = 1;
    }

}


void cMovelist::score_killer(uint move, int score, uint ply)
{

  ASS(ply>=0 && ply<maxply);
  ASS(onbrd(FROM(move))&&onbrd(TO(move)));
  ASS(score>=-matescore&&score<=matescore);
  if(score > matescore-200)
  {
   killers.mk[ply] = move;
   return;
  }

  if( !(FlagCAPEP&move) )
  {
     if(move != killers.k1[ply])
     {
       killers.k2[ply] = killers.k1[ply];
       killers.k1[ply] = move;
     }
     else
     {
      killers.k2[ply] = move;
     }
  }
}


cMovelist::cMovelist()
{
    uint pce,sq;
    for(pce = pE; pce <= pbK; ++pce)
    {
        for(sq = 0; sq < BRDSQ; ++sq)
        histab.value[pce][sq] = 1;
    }
    histab.max = 1;
    init_opt();
}



int cMovelist::ordercapture(uint move, cBoard &pboard, cMaterial &material)
{

  int from,to,val;
  from = FROM(move);
  to = TO(move);
  uint side;
  uint pcefrom = pboard.p2board()[from];
  uint pceto = pboard.p2board()[to];

  ASS(piecegood(pcefrom));
  ASS(piecegood(pceto));
  ASS(onbrd(from));
  ASS(onbrd(to));

  if(PROM(move))//promotion
  {
      if(PROM(move)==pbQ||PROM(move)==pwQ)//queen
      {
          stats.capture++;
          return Q_PROM_CAPT;
      }
      else
      {
          stats.badcapture++;
          return MINORPROM;
      }
  }
  else//not a prom
  {
	val = piecevals[pceto] - piecevals[pcefrom];

	if(val>0)
	{
	 ASS( (WIN_CAPT+val) < M_KILLER && (WIN_CAPT+val) > Q_PROM_CAPT );
	 stats.capture++;
	 return WIN_CAPT+val;
	}
    else if(val == 0)
    {
     ASS(  equalcap[pcefrom] < Q_PROM && equalcap[pcefrom] > SEECAP );
     stats.capture++;
     return equalcap[pcefrom];
    }
    else
    {
        side = pboard.getside();
        ASS(side==cW||side==cB);
        if(isattack(pboard, material, side^1, to))
        {
           stats.badcapture++;
           return 1;
        }
        else
        {
           stats.capture++;
           return SEECAP;
        }
    }
  }
}

void cMovelist::ordermove(uint move, uint &cap, const uint &flag, const uint &prom, uint &ply, uint pce, cBoard &pboard, int *score, cMaterial &material)
{
     *score = -200;
     if(move==pvmove && opt->hashmove)
     {
        *score = HASH;
         stats.hashmove++;
     }
     else if(opt->matekiller && move==killers.mk[ply])
     {
         *score = M_KILLER;
         stats.matekiller++;
     }
     else if( cap && opt->mvvlva )
     {
       ASS(cap>=pwP&&cap<pwK);
       *score = ordercapture(move, pboard, material);
     }
     else if(move & FlagEP)
     {
         *score = GCAP_PP;
         stats.epcapture++;
     }
     else if(prom!=pE)
     {
         ASS(prom>=pwN&&prom<=pbQ);
         if(prom==pwQ||prom==pbQ)
         {
             *score=Q_PROM;
             stats.qprom++;
         }
         else
         {
             *score=MINORPROM;
             stats.minorprom++;
         }
     }
     else if(move==killers.k1[ply] && opt->killer)
     {
         *score = KILLER1;
         stats.killer1++;
     }
     else if(move==killers.k2[ply] && opt->killer)
     {
         *score = KILLER2;
         stats.killer2++;
     }
     else if (move & FlagCA)
     {
         ASS(files[TO(move)]==FILEC || files[TO(move)]==FILEG);
         stats.castle++;
         if(files[TO(move)]==FILEC)
         {
             *score = OOO;
         }
         else
         {
             *score = OO;
         }
     }
     else
     {
        /*if(opt->histab)
	    {
	        stats.histab++;
	        *score  = (histab.value[pce][TO(move)] * HISMAX) / (histab.max + 1);
	        ASS(*score<HISMAX);
	    }*/

	    ASS(piecegood(pce));
	    ASS(sqto64(TO(move))>=0&&sqto64(TO(move))<=63);
	    ASS(sqto64(FROM(move))>=0&&sqto64(FROM(move))<=63);
           if((material.getmaterial(cW) + material.getmaterial(cB)) > ENDMAT)
           {
               tab = midordertab[pce];
           }
           else
           {
               tab = endordertab[pce];
           }

           *score=tab[sqto64(TO(move))]-tab[sqto64(FROM(move))];
           stats.histab++;
           ASS(*score < int(HISMAX) );
	 }
	 ASS(*score<=HASH && *score>=-100 && *score!=-200);
}

void cMovelist::addpawnmove(uint &from, uint &to, uint &cap, uint side, uint &ply, uint pce, cBoard &pboard, cMaterial &material)
{
     ASS(onbrd(from));
     ASS(onbrd(to));
     ASS(colourgood(side));
     ASS(piecegood(cap));
     ASS(ply<maxply);
     ASS(pce==pwP||pce==pbP);

     if(side==cW)
     {
         if(ranks[from]==RANK7)
         {
             ASS(ranks[to]==RANK8);
             this->addmove(from,to,cap,FlagE,pwQ,ply,pce,pboard,material);
             this->addmove(from,to,cap,FlagE,pwN,ply,pce,pboard,material);
             this->addmove(from,to,cap,FlagE,pwR,ply,pce,pboard,material);
             this->addmove(from,to,cap,FlagE,pwB,ply,pce,pboard,material);
         }
         else
         {
             this->addmove(from,to,cap,FlagE,FlagE,ply,pce,pboard,material);
         }

     }
     else
     {
         ASS(side==cB);
         if(ranks[from]==RANK2)
         {
             ASS(ranks[to]==RANK1);
             this->addmove(from,to,cap,FlagE,pbQ,ply,pce,pboard,material);
             this->addmove(from,to,cap,FlagE,pbN,ply,pce,pboard,material);
             this->addmove(from,to,cap,FlagE,pbR,ply,pce,pboard,material);
             this->addmove(from,to,cap,FlagE,pbB,ply,pce,pboard,material);
         }
         else
         {
             this->addmove(from,to,cap,FlagE,FlagE,ply,pce,pboard,material);
         }
     }
}

void cMovelist::addmove(uint &from, uint &to, uint &cap, const uint &flag, const uint &prom, uint &ply, uint pce, cBoard &pboard, cMaterial &material)
{
     ASS(ply<maxply);
     ASS(pce>=pwP&&pce<=pbK);
     ASS(cap>=pE&&cap<=pbK);
     ASS(prom>=pE&&prom<=pbK);
     ASS(onbrd(from));
     ASS(onbrd(to));

     uint count = movecount[ply];
     uint move = (from | (to<<7) | (cap<<16) | (prom<<20) | flag);
     movelist[ply][count] = move;

     movescores[ply][count] = -200;
     ordermove(move, cap, flag, prom, ply, pce, pboard, &movescores[ply][count], material);
     ASS(movescores[ply][count]<=HASH && movescores[ply][count]>=-100 && movescores[ply][count]!=-200);
     movecount[ply]++;
}

void cMovelist::printmovelist(uint &thisply)
{
     uint count = movecount[thisply];
     ASS(thisply<maxply);
     ASS(count<maxmoves);
     uint i;
     cout<<endl<<"|--------------------|"<<endl;
     cout<<"list of "<<count<<" moves"<<endl;
     for(i = 0; i < count; ++i)
     {
           printmovelong(movelist[thisply][i]);
     }
     cout<<"|--------------------|"<<endl;
}


void cMovelist::printatplymovelist(uint thisply)
{
     ASS(thisply<maxply);
     uint count = movecount[thisply];
     ASS(count<maxmoves);
     uint i;
     cout<<endl<<"|--------------------|"<<endl;
     cout<<"list of "<<count<<" moves"<<endl;
     for(i = 0; i < count; ++i)
     {
           printmovelong(movelist[thisply][i]);
     }
     cout<<"|--------------------|"<<endl;
}


void cMovelist::says_stats()
{
#ifdef DEBUG
    cout<<"\nOrdered move stats: ";
    cout<<"\n killer1: "<<stats.killer1;
    cout<<" killer2: "<<stats.killer2;
    cout<<" matekiller: "<<stats.matekiller;
    cout<<"\nhistab: "<<stats.histab;
    cout<<" capture: "<<stats.capture;
    cout<<" badcapture: "<<stats.badcapture;
    cout<<"\nhashmove: "<<stats.hashmove;
    cout<<" qprom: "<<stats.qprom;
    cout<<" minorprom: "<<stats.minorprom;
#endif
    if(logger.islog())
    {
    logger.file<<"\nOrdered move stats: ";
    logger.file<<"\n killer1: "<<stats.killer1;
    logger.file<<" killer2: "<<stats.killer2;
    logger.file<<" matekiller: "<<stats.matekiller;
    logger.file<<"\nhistab: "<<stats.histab;
    logger.file<<" capture: "<<stats.capture;
    logger.file<<" badcapture: "<<stats.badcapture;
    logger.file<<"\nhashmove: "<<stats.hashmove;
    logger.file<<" qprom: "<<stats.qprom;
    logger.file<<" minorprom: "<<stats.minorprom;
    }
}
